<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-Engine-Files-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwadapter="urn:WebWorks-XSLT-Extension-Adapter"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwmode wwlinks wwfiles wwdoc wwsplits wwtoc wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwadapter wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterPDFSplitFileType" />
 <xsl:param name="ParameterType" />


 <xsl:namespace-alias stylesheet-prefix="wwfiles" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwsplits-files-by-documentid" match="wwsplits:File" use="@documentID" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Generate PDF files? -->
   <!--                     -->
   <xsl:if test="wwprojext:GetFormatSetting('pdf-per-document') = 'true'">
    <!-- Define TOC styles -->
    <!--                   -->
    <xsl:variable name="VarTOCStylesAsXML">
     <xsl:variable name="VarParagraphRules" select="$GlobalProject/wwproject:Project/wwproject:GlobalConfiguration/wwproject:Rules[@Type = 'Paragraph']/wwproject:Rule" />
     <xsl:for-each select="$VarParagraphRules">
      <xsl:variable name="VarParagraphRule" select="." />

      <xsl:variable name="VarRule" select="wwprojext:GetRule('Paragraph', $VarParagraphRule/@Key)" />
      <xsl:variable name="VarTOCLevelOption" select="$VarRule/wwproject:Options/wwproject:Option[@Name = 'toc-level']/@Value" />
      <xsl:if test="(string-length($VarTOCLevelOption) &gt; 0) and (number($VarTOCLevelOption) &gt; 0)">
       <wwadapter:TOC stylename="{$VarParagraphRule/@Key}" level="{$VarTOCLevelOption}" />
      </xsl:if>
     </xsl:for-each>
    </xsl:variable>
    <xsl:variable name="VarTOCStyles" select="msxsl:node-set($VarTOCStylesAsXML)/wwadapter:TOC" />

    <!-- Groups -->
    <!--        -->
    <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
    <xsl:variable name="VarProgressProjectGroupsStart" select="wwprogress:Start(count($VarProjectGroups))" />
    <xsl:for-each select="$VarProjectGroups">
     <xsl:variable name="VarProjectGroup" select="." />

     <xsl:variable name="VarProgressProjectGroupStart" select="wwprogress:Start(1)" />

     <!-- Load splits -->
     <!--             -->
     <xsl:for-each select="$GlobalFiles[1]">
      <xsl:variable name="VarFilesSplits" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterSplitsType))[1]" />
      <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesSplits/@path)" />

      <!-- Process group input documents -->
      <!--                               -->
      <xsl:for-each select="$GlobalInput[1]">
       <!-- Iterate input documents -->
       <!--                         -->
       <xsl:variable name="VarFilesByType" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterDependsType))" />
       <xsl:variable name="VarProgressDocumentsStart" select="wwprogress:Start(count($VarFilesByType))" />
       <xsl:for-each select="$VarFilesByType">
        <xsl:variable name="VarDocument" select="." />

        <xsl:variable name="VarProgressDocumentStart" select="wwprogress:Start(1)" />

        <!-- Define group documents -->
        <!--                        -->
        <xsl:variable name="VarDocumentPDFFilePath">
         <xsl:for-each select="$VarSplits[1]">
          <xsl:variable name="VarDocumentPDFSplitsFile" select="key('wwsplits-files-by-documentid', $VarDocument/@documentID)[@type = $ParameterPDFSplitFileType]" />
          <xsl:value-of select="$VarDocumentPDFSplitsFile/@path" />
         </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="VarAdapterGroupFilesAsXML">
         <xsl:for-each select="$VarProjectGroup//wwproject:Document">
          <xsl:variable name="VarProjectDocument" select="." />

          <xsl:for-each select="$VarSplits[1]">
           <xsl:variable name="VarPDFSplitsFile" select="key('wwsplits-files-by-documentid', $VarProjectDocument/@DocumentID)[@type = $ParameterPDFSplitFileType]" />
           <xsl:for-each select="$VarPDFSplitsFile">
            <wwadapter:File source="{wwprojext:GetDocumentPath($VarProjectDocument/@DocumentID)}">
             <xsl:attribute name="target">
              <xsl:choose>
               <!-- Same file? -->
               <!--            -->
               <xsl:when test="wwstring:ToLower($VarPDFSplitsFile/@path) = wwstring:ToLower($VarDocumentPDFFilePath)">
                <xsl:value-of select="''" />
               </xsl:when>

               <!-- Unique file -->
               <!--             -->
               <xsl:otherwise>
                <xsl:value-of select="wwfilesystem:GetRelativeTo($VarPDFSplitsFile/@path, $VarDocumentPDFFilePath)" />
               </xsl:otherwise>
              </xsl:choose>
             </xsl:attribute>
            </wwadapter:File>
           </xsl:for-each>
          </xsl:for-each>
         </xsl:for-each>
        </xsl:variable>
        <xsl:variable name="VarAdapterGroupFiles" select="msxsl:node-set($VarAdapterGroupFilesAsXML)/wwadapter:File" />

        <!-- Determine PDF PostScript file path -->
        <!--                                    -->
        <xsl:variable name="VarPath" select="wwfilesystem:Combine(wwfilesystem:GetDirectoryName($VarDocument/@path), concat(translate($ParameterType, ':', '_'),'.ps'))" />
        <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, $GlobalProject/wwproject:Project/@ChangeID, $VarDocument/@groupID, $VarDocument/@documentID, $GlobalActionChecksum)" />
        <xsl:if test="not($VarUpToDate)">
         <!-- Generate PostScript for PDF -->
         <!--                             -->
         <xsl:variable name="VarIgnoreSetPDFPageNumberOffset" select="wwadapter:SetPDFPageNumberOffset(0)" />
         <xsl:variable name="VarNumberOfPages" select="wwadapter:GeneratePostScriptForPDF(wwprojext:GetDocumentPath($VarDocument/@documentID), $VarDocument/@path, true(), $VarTOCStyles, $VarAdapterGroupFiles[not(@source = wwprojext:GetDocumentPath($VarDocument/@documentID))], $VarPath)" />
        </xsl:if>

        <!-- Track PDF PostScript file -->
        <!--                           -->
        <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="{$GlobalProject/wwproject:Project/@ChangeID}" groupID="{$VarDocument/@groupID}" documentID="{$VarDocument/@documentID}" actionchecksum="{$GlobalActionChecksum}">
         <wwfiles:Depends path="{$VarFilesSplits/@path}" checksum="{$VarFilesSplits/@checksum}" groupID="{$VarFilesSplits/@groupID}" documentID="{$VarFilesSplits/@documentID}" />
         <wwfiles:Depends path="{$VarDocument/@path}" checksum="{$VarDocument/@checksum}" groupID="{$VarDocument/@groupID}" documentID="{$VarDocument/@documentID}" />
        </wwfiles:File>

        <xsl:variable name="VarProgressDocumentEnd" select="wwprogress:End()" />
       </xsl:for-each>

       <xsl:variable name="VarProgressDocumentsEnd" select="wwprogress:End()" />
      </xsl:for-each>
     </xsl:for-each>
 
     <xsl:variable name="VarProgressProjectGroupEnd" select="wwprogress:End()" />
    </xsl:for-each>

    <xsl:variable name="VarProgressProjectGroupsEnd" select="wwprogress:End()" />
   </xsl:if>

  </wwfiles:Files>
 </xsl:template>
</xsl:stylesheet>
